***********************************************************************
*
* busybox uwindow.asm -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements windows in
* the busybox program.
*
***********************************************************************

               case on

               copy 2/ainclude/e16.resources
               copy busybox.equ

               mcopy macros/uwindow.macros

               longi on
               longa on

MainWindowID        gequ $2000

************************************************************************
*
* drawThisWindow
*
* This routine draws the contents of all the windows.
*
drawThisWindow start

               phb                      ;This is not needed now.  This function
               phk                      ;may get more complicated for developers,
               plb                      ;and may include references to global data,
*                                       ;at which time this would be necessary.
               pha
               pha
               _GetPort
               _DrawControls

               plb                      ;Restore dataBank.
               rtl

               end

************************************************************************
*
* doCloseTop
*
* This routine closes the topmost window.  We do a little work to
* prevent the main window from being closed.
*
doCloseTop     start

               DefineStack

tempWin        long

saveDPage      word
returnAddr     word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for tempWin.
               pha
               tsc                      ;Set directPage register.
               tcd

               pha                      ;Who's on top?
               pha
               _FrontWindow
               PullLong tempWin

               ldy #1|2                 ;Find the window entry.  We start at 1
loop           lda windowList,y         ;since we never close the top window.
               cmp tempWin              ;When we find it, we close it and zero
               bne next                 ;the entry.
               lda windowList+2,y
               cmp tempWin+2
               beq gotit
next           iny
               iny
               iny
               iny
               cpy #NumWindows|2
               bcc loop
               bra notOurs              ;It isn't one of ours.

gotit          lda #0
               sta windowList,y
               sta windowList+2,y
               pei tempWin+2
               pei tempWin
               _CloseWindow
               bra allDone

notOurs        pha                      ;Find out what kind of window.
               pei tempWin+2
               pei tempWin
               _GetSysWFlag
               pla                      ;Well, what's it going to be?
               beq allDone              ;Don't close that last window of ours.
               pei tempWin+2
               pei tempWin
               _CloseNDAByWinPtr

allDone        pla                      ;Remove space for tempWin.
               pla
               pld                      ;Restore directPage register.
               rts

               end

******************************************************************************
*
* openThisWindow
*
* This routine either opens the specified window or brings it to the top
* if it is already open.
*
* If it is not open, we open it with NewWindow2 invisibly, adjust the window's
* location and then show and select the window.
*
openThisWindow start

               DefineStack

wptr           long

saveDPage      word
returnAddr     word

ctlid          word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for wptr.
               pha
               tsc
               tcd                      ;Set directPage register.

               lda ctlid
               asl a
               asl a
               tay
               lda windowList,y
               sta wptr
               lda windowList+2,y
               sta wptr+2

               ora wptr                 ;Hi-word in acc.
               bne justSelect           ;Window already open.

               pha                      ;Result space
               pha
               pea 0|-16                ;NULL
               pea 0
               pea 0|-16                ;NULL
               pea 0
               pea drawThisWindow|-16   ;Update procedure
               pea drawThisWindow
               pea 0|-16                ;NULL
               pea 0
               pea 2                    ;What type.
               pea 0|-16                ;Hi-word of below ctlid.
               lda ctlid
               clc
               adc #MainWindowID
               pha
               pea rWindParam1
               _NewWindow2
               lda ctlid
               asl a
               asl a
               tay
               pla
               sta wptr                 ;Store window pointer in list.
               sta windowList,y
               pla
               sta wptr+2
               sta windowList+2,y

               lda ctlid
               cmp #Prog1ID
               bcs noMove
               lda staggerCount
               asl a
               asl a
               asl a
               adc #50
               pha                      ;New xloc.
               pha                      ;New yloc.
               pei wptr+2
               pei wptr
               _MoveWindow
               lda staggerCount
               inc a
               cmp #7                   ;Up to 7 windows to stagger.
               bcc aa
               sbc #7
aa             sta staggerCount

noMove         pei wptr+2               ;Window opened as invisible so
               pei wptr                 ;that it could be moved without
               _ShowWindow              ;affecting up the screen.

justSelect     pei wptr+2               ;Make sure window is on top.
               pei wptr
               _SelectWindow

               pla                      ;Remove space for wptr.
               pla
               pld                      ;Restore directPage register.
               plx                      ;Keep return address.
               pla                      ;Remove passed parameter.
               phx                      ;Put return address back
               rts                      ;  and return.

               end

*******************************************************************************
*
* setupWindows
*
* Sets up windowList record for use through out the program.
*
setupWindows   start

               ldy #NumWindows|2-2
               lda #0
loop           sta windowList,y
               dey
               dey
               bne loop                 ;Element 0 will be set below.

               pha                      ;Result space
               pha
               pea 0|-16                ;NULL
               pea 0
               pea 0|-16                ;NULL
               pea 0
               pea drawThisWindow|-16   ;Update procedure
               pea drawThisWindow
               pea 0|-16                ;NULL
               pea 0
               pea 2                    ;What type.
               pea MainWindowID|-16
               pea MainWindowID
               pea rWindParam1
               _NewWindow2
               pla
               sta windowList
               pla
               sta windowList+2
               rts

               end
